/** @file   objectmessage.cpp
 * @brief   Implementation of ObjectMessage - class.
 * @version $Revision: 1.2 $
 * @author  Tomi Lamminsaari
 */

#include "objectmessage.h"
#include "datatypes.h"
#include "gameobject.h"

namespace WeWantWar {

///
/// Static members, constants and datatypes
/// =======================================

int ObjectMessage::s_messageNumbers = 0;

const ObjectMessage::MessageID ObjectMessage::KChangeTarget;
const ObjectMessage::MessageID ObjectMessage::KDefault;
const ObjectMessage::MessageID ObjectMessage::KResponse;
const ObjectMessage::MessageID ObjectMessage::KControllerState;
const ObjectMessage::MessageID ObjectMessage::KWeaponChange;


/** Creates a response message
 */
ObjectMessage ObjectMessage::createResponse( const ObjectMessage& rMessage )
{
  ObjectMessage tmpMessage( rMessage );
  tmpMessage.m_id = OBJMESS_RESPONSE;
  tmpMessage.m_pSender = rMessage.m_pDestination;
  tmpMessage.m_pDestination = rMessage.m_pSender;
  tmpMessage.m_messageNum = rMessage.m_messageNum;
  return tmpMessage;
}



///
/// Constructors, destructor and operators
/// ======================================

/** Constructor
 */
ObjectMessage::ObjectMessage() :
  m_id( OBJMESS_DEFAULT ),
  m_messageNum( s_messageNumbers++ ),
  m_pSender( 0 ),
  m_pDestination( 0 )
{
}



/** Constructor
 */
ObjectMessage::ObjectMessage( MessageID messID ) :
  m_id( messID ),
  m_messageNum( s_messageNumbers++ )
{
}



/** Copy constructor
 */
ObjectMessage::ObjectMessage( const ObjectMessage& rObjMess ) :
  m_id( rObjMess.m_id )
{
}


/** Destructor
 */
ObjectMessage::~ObjectMessage()
{
}



/** Assingment operator
 */
ObjectMessage& ObjectMessage::operator= ( const ObjectMessage& rObjMess )
{
  if ( this != &rObjMess ) {
    m_id = rObjMess.m_id;
  }
  return *this;
}


} // end of namespace
